/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"download"})
public class DownloadClient
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DownloadClient.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;
    @Value(value="${dlcm.download.url}")
    private String downloadUrl;

    public DownloadClient(StandaloneRestClientTool restClientTool) {
        super(restClientTool);
    }

    public void run(String ... arg0) {
        String prefix = "[Download]";
        Path destinationFile = Paths.get(this.loadFolder + "/downloaded-file", new String[0]);
        try {
            log.info("{} Downloading {} in {}", new Object[]{"[Download]", this.downloadUrl, this.loadFolder});
            this.downloadContentWithToken(this.downloadUrl, destinationFile);
            log.info("{} {} downloaded successfully", (Object)"[Download]", (Object)destinationFile);
        }
        catch (Exception e) {
            log.error("{} {} download failed", new Object[]{"[Download]", destinationFile, e});
        }
    }
}

