/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools.common;

import ch.dlcm.model.DataCategory;
import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.model.preingest.DepositDataFile;
import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;

public class DepositUploader
extends DLCMTools {
    private static final Logger log = LoggerFactory.getLogger(DepositUploader.class);

    public DepositUploader(StandaloneRestClientTool restClientTool, String preIngestUrl, String licenseId) {
        super(restClientTool);
        this.preIngestUrl = preIngestUrl;
        this.licenseId = licenseId;
    }

    public void checkDepositDatafiles(String prefix, String depositId, Path folder) {
        int error = 0;
        int fileTotal = 0;
        int dfTotal = 0;
        for (Path dataCat : FileTool.scanFolder((Path)folder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            for (Path dataType : FileTool.scanFolder((Path)dataCat, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                List folderList = this.scanAllFolders(dataType);
                for (Path fld : folderList) {
                    String relativeLocation = "";
                    if (!fld.equals(dataType)) {
                        relativeLocation = dataType.relativize(fld).toString();
                    }
                    List fileList = FileTool.scanFolder((Path)fld, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                    fileTotal += fileList.size();
                    List dataFileList = this.findDataFiles(depositId, relativeLocation);
                    dfTotal += dataFileList.size();
                    if (fileList.size() != dataFileList.size()) {
                        ++error;
                        log.error("{} Wrong number of items in {}", (Object)prefix, (Object)relativeLocation);
                    }
                    for (DepositDataFile dataFile : dataFileList) {
                        if (!dataFile.getDataCategory().equals((Object)DataCategory.valueOf((String)dataCat.getFileName().toString()))) {
                            log.warn("{} Wrong data category for {} in {}: {} <> {}", new Object[]{prefix, dataFile.getFileName(), fld.getFileName(), dataCat, dataFile.getDataCategory()});
                        }
                        if (dataFile.getDataType().equals((Object)DataCategory.valueOf((String)dataType.getFileName().toString()))) continue;
                        log.warn("{} Wrong data category for {} in {}: {} <> {}", new Object[]{prefix, dataFile.getFileName(), fld.getFileName(), dataCat, dataFile.getDataType()});
                    }
                }
            }
        }
        log.info("{} Data files check for deposit {} : {}  error(s), {} file(s), {} data file(s)", new Object[]{prefix, depositId, error, fileTotal, dfTotal});
    }

    public void importDeposit(String organizationalUnitId, Path folder) {
        String prefix = "[OrganizationalUnit=" + organizationalUnitId + " Deposit] ";
        log.info("Scanning deposit folder: {}", (Object)folder);
        for (Path d : FileTool.scanFolder((Path)folder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            log.info("{} Importing {}", (Object)prefix, (Object)d);
            Deposit deposit = this.sendDeposit(prefix, organizationalUnitId, d.getFileName().toString());
            if (deposit == null) continue;
            this.loadDepositDatafiles(prefix, deposit, d, false);
        }
    }

    public void loadDepositDatafiles(String prefix, Deposit deposit, Path folder, boolean local) {
        int count = 0;
        int total = 0;
        for (Path dataCat : FileTool.scanFolder((Path)folder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            for (Path dataType : FileTool.scanFolder((Path)dataCat, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                if (dataType.getFileName().toString().equals(DataCategory.CustomMetadata.name())) {
                    for (Path metadataType : FileTool.scanFolder((Path)dataType, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                        List fileList = this.scanAll(metadataType);
                        total += fileList.size();
                        count = (int)((long)count + this.loadFiles(prefix, deposit, local, dataCat.getFileName().toString(), dataType.getFileName().toString(), metadataType.getFileName().toString(), metadataType, fileList));
                    }
                    continue;
                }
                List fileList = this.scanAll(dataType);
                total += fileList.size();
                count = (int)((long)count + this.loadFiles(prefix, deposit, local, dataCat.getFileName().toString(), dataType.getFileName().toString(), null, dataType, fileList));
            }
        }
        log.info("{} Data files loading end {} : {} uploaded file(s) of {} data file(s)", new Object[]{prefix, folder, count, total});
    }

    public long loadFiles(String prefix, Deposit deposit, boolean local, String dataCategory, String dataType, String metadataType, Path parent, List<Path> fileList) {
        long count = 0L;
        for (Path f : fileList) {
            String relLocation = "/" + String.valueOf(parent.relativize(f.getParent()));
            String dfId = null;
            dfId = local ? this.createLocalDepositDataFile(prefix, deposit, f.toUri(), dataCategory, dataType, relLocation, metadataType) : this.addDataFile(this.preIngestUrl + "/deposits/" + deposit.getResId() + "/upload", f, dataCategory, dataType, relLocation, metadataType, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (dfId == null) {
                log.error("{} Cannot add data file ({}) to deposit (ID={})", new Object[]{prefix, parent.relativize(f), deposit.getResId()});
                continue;
            }
            ++count;
            log.info("{} Data file ({}) added to deposit (ID={})", new Object[]{prefix, parent.relativize(f), deposit.getResId()});
        }
        return count;
    }
}

