/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools.common;

import ch.dlcm.model.AbstractDataFile;
import ch.dlcm.model.DataCategory;
import ch.dlcm.model.oais.ArchivalInfoPackage;
import ch.dlcm.model.oais.ArchiveContainer;
import ch.dlcm.model.oais.SubmissionInfoPackage;
import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.model.preingest.DepositDataFile;
import ch.dlcm.model.settings.OrganizationalUnit;
import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.security.TokenUsage;
import ch.unige.solidify.util.CollectionTool;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import ch.unige.solidify.util.StringTool;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public abstract class DLCMTools {
    public static final String DLCM_TOOL_AIP = "aip";
    public static final String DLCM_TOOL_CREATION = "created by DLCM Tools";
    public static final String DLCM_TOOL_DEPOSIT = "deposit";
    public static final String DLCM_TOOL_SIP = "sip";
    private static final Logger log = LoggerFactory.getLogger(DLCMTools.class);
    @Value(value="${dlcm.module.admin.url}")
    protected String adminUrl;
    @Value(value="${dlcm.module.archival-storage.urls}[0]")
    protected String archivalStorageUrl;
    @Value(value="${dlcm.module.ingest.url}")
    protected String ingestUrl;
    @Value(value="${dlcm.license.default.id:CC-BY-4.0}")
    protected String licenseId;
    @Value(value="${dlcm.module.preingest.url}")
    protected String preIngestUrl;
    protected StandaloneRestClientTool restClientTool;

    protected DLCMTools(StandaloneRestClientTool restClientTool) {
        this.restClientTool = restClientTool;
    }

    public String sendAIP(String prefix, String organizationalUnitId, Path df, ArchiveContainer aipContainer) {
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            ArchivalInfoPackage aip = new ArchivalInfoPackage();
            aip.setArchiveContainer(aipContainer);
            aip.getInfo().setName(df.getFileName().toString());
            aip.getInfo().setDescription(DLCM_TOOL_CREATION);
            aip.getInfo().setOrganizationalUnitId(organizationalUnitId);
            ArchivalInfoPackage resAip = (ArchivalInfoPackage)restClt.postForObject(this.archivalStorageUrl + "/aip", (Object)aip, ArchivalInfoPackage.class, new Object[0]);
            if (resAip == null || resAip.getResId() == null) {
                log.error("{} Cannot create AIP for {}", (Object)prefix, (Object)df);
                return null;
            }
            log.info("{} AIP created: {} (ID={})", new Object[]{prefix, df.getFileName(), resAip.getResId()});
            if (this.addDataFile(this.archivalStorageUrl + "/aip/" + resAip.getResId() + "/upload", df, null, null, null, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */) != null) {
                return resAip.getResId();
            }
            log.error("{} Cannot add package for AIP {}", (Object)prefix, (Object)resAip.getResId());
        }
        catch (Exception e) {
            log.error("{} Cannot send AIP ({}): {}", new Object[]{prefix, df, e.getMessage(), e});
        }
        return null;
    }

    public void sendSIP(String prefix, String organizationalUnitId, Path df) {
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            SubmissionInfoPackage sip = new SubmissionInfoPackage();
            sip.getInfo().setName(df.getFileName().toString());
            sip.getInfo().setDescription(DLCM_TOOL_CREATION);
            sip.getInfo().setOrganizationalUnitId(organizationalUnitId);
            SubmissionInfoPackage resSip = (SubmissionInfoPackage)restClt.postForObject(this.ingestUrl + "/sip", (Object)sip, SubmissionInfoPackage.class, new Object[0]);
            if (resSip == null || resSip.getResId() == null) {
                log.error("{} Cannot create SIP for {}", (Object)prefix, (Object)df);
                return;
            }
            log.info("{} SIP created: {} (ID={})", new Object[]{prefix, df.getFileName(), resSip.getResId()});
            String url = this.ingestUrl + "/sip/" + resSip.getResId() + "/upload";
            2 responseType = new /* Unavailable Anonymous Inner Class!! */;
            if (this.addDataFile(url, df, null, null, null, null, (ParameterizedTypeReference)responseType) == null) {
                log.error("{} Cannot add package for SIP {}", (Object)prefix, (Object)resSip.getResId());
            }
        }
        catch (Exception e) {
            log.error("{} Cannot send SIP ({}): {}", new Object[]{prefix, df, e.getMessage(), e});
        }
    }

    protected <T extends AbstractDataFile> String addDataFile(String url, Path df, String dataCat, String dataType, String relLocation, String metadataType, ParameterizedTypeReference<T> responseType) {
        AbstractDataFile dataFile;
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"file", (Object)new FileSystemResource(df.toFile()));
        if (!StringTool.isNullOrEmpty((String)dataCat)) {
            map.add((Object)"category", (Object)dataCat);
        }
        if (!StringTool.isNullOrEmpty((String)dataType)) {
            map.add((Object)"type", (Object)dataType);
        }
        if (!StringTool.isNullOrEmpty((String)relLocation)) {
            map.add((Object)"folder", (Object)("{base64}" + StringTool.encode64((String)relLocation)));
        }
        if (!StringTool.isNullOrEmpty((String)metadataType)) {
            map.add((Object)"metadataType", (Object)metadataType);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity requestEntity = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            ResponseEntity responseEntity = restClt.exchange(url, HttpMethod.POST, requestEntity, responseType, new Object[0]);
            dataFile = (AbstractDataFile)responseEntity.getBody();
        }
        catch (Exception e) {
            log.error("Error adding data file " + url, (Throwable)e);
            return null;
        }
        if (dataFile != null) {
            return dataFile.getResId();
        }
        return null;
    }

    protected String createLocalDepositDataFile(String prefix, Deposit deposit, URI file, String dataCat, String dataType, String relLocation, String metadataType) {
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            DepositDataFile df = new DepositDataFile(deposit);
            df.setDataCategory(DataCategory.valueOf((String)dataCat));
            df.setDataType(DataCategory.valueOf((String)dataType));
            df.setRelativeLocation(relLocation);
            if (!StringTool.isNullOrEmpty((String)metadataType)) {
                df.getMetadataType().setResId(metadataType);
            }
            df.setSourceData(file);
            DepositDataFile resDf = (DepositDataFile)restClt.postForObject(this.preIngestUrl + "/deposits/" + deposit.getResId() + "/data", (Object)df, DepositDataFile.class, new Object[0]);
            if (resDf == null || resDf.getResId() == null) {
                log.error("{} Cannot create deposit data file (URI={})", (Object)prefix, (Object)file);
                return null;
            }
            log.info("{} Deposit data file created: {} (ID={})", new Object[]{prefix, file, resDf.getResId()});
            return resDf.getResId();
        }
        catch (Exception e) {
            log.error("{} Cannot send deposit data file (name={}): {}", new Object[]{prefix, file, e.getMessage(), e});
            return null;
        }
    }

    protected String createOrganizationUnit(String prefix, String orgUnitName) {
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            OrganizationalUnit orgUnit = new OrganizationalUnit();
            orgUnit.setName(orgUnitName);
            orgUnit.setDescription(DLCM_TOOL_CREATION);
            OrganizationalUnit resOrgUnit = (OrganizationalUnit)restClt.postForObject(this.adminUrl + "/organizational-units", (Object)orgUnit, OrganizationalUnit.class, new Object[0]);
            if (resOrgUnit == null || resOrgUnit.getResId() == null) {
                log.error("{} Cannot create OrganizationalUnit (name={})", (Object)prefix, (Object)orgUnitName);
                return null;
            }
            log.info("{} OrganizationalUnit created: {} (ID={})", new Object[]{prefix, orgUnitName, resOrgUnit.getResId()});
            return resOrgUnit.getResId();
        }
        catch (Exception e) {
            log.error("{} Cannot send OrganizationalUnit (name={}): {}", new Object[]{prefix, orgUnitName, e.getMessage(), e});
            return null;
        }
    }

    protected boolean deleteDataFile(String depositId, String depositDataFileId) {
        RestTemplate restClt = this.restClientTool.getClientWithPlusEncoderInterceptor();
        String url = this.preIngestUrl + "/deposits/" + depositId + "/data/" + depositDataFileId;
        restClt.delete(url, new Object[0]);
        return true;
    }

    protected List<DepositDataFile> findDataFiles(String depositId, String relativeLocation) {
        RestTemplate restClt = this.restClientTool.getClientWithPlusEncoderInterceptor();
        String url = this.preIngestUrl + "/deposits/" + depositId + "/data?relativeLocation=/" + relativeLocation + "&size=2000";
        String jsonResult = (String)restClt.getForObject(url, String.class, new Object[0]);
        return CollectionTool.getList((String)jsonResult, DepositDataFile.class);
    }

    protected Deposit findDeposit(String depositId) {
        RestTemplate restClt = this.restClientTool.getClient();
        try {
            return (Deposit)restClt.getForObject(this.preIngestUrl + "/deposits/" + depositId, Deposit.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.NOT_FOUND) {
                return null;
            }
            throw e;
        }
    }

    protected List<String> findFolders(String depositId) {
        RestTemplate restClt = this.restClientTool.getClientWithPlusEncoderInterceptor();
        String url = this.preIngestUrl + "/deposits/" + depositId + "/data/list-folders";
        return (List)restClt.getForObject(url, List.class, new Object[0]);
    }

    protected String findOrganizationUnit(String organizationalUnitName) {
        RestTemplate restClt = this.restClientTool.getClient();
        String jsonResult = (String)restClt.getForObject(this.adminUrl + "/organizational-units?name=" + organizationalUnitName, String.class, new Object[0]);
        List list = CollectionTool.getList((String)jsonResult, OrganizationalUnit.class);
        if (list.isEmpty()) {
            return null;
        }
        for (OrganizationalUnit unit : list) {
            if (!unit.getName().equals(organizationalUnitName)) continue;
            return unit.getResId();
        }
        return null;
    }

    protected List<Path> scanAll(Path root) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (Path d : FileTool.scanFolder((Path)root, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            list.addAll(this.scanAll(d));
        }
        list.addAll(FileTool.scanFolder((Path)root, x$0 -> Files.isRegularFile(x$0, new LinkOption[0])));
        return list;
    }

    protected List<Path> scanAllFolders(Path root) {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(root);
        for (Path d : FileTool.scanFolder((Path)root, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            list.addAll(this.scanAllFolders(d));
        }
        return list;
    }

    protected Deposit sendDeposit(String prefix, String organizationalUnitId, String title) {
        try {
            RestTemplate restClt = this.restClientTool.getClient();
            Deposit deposit = new Deposit();
            deposit.setTitle(title);
            deposit.setDescription("Data set created by DLCM Tools: " + title);
            deposit.setOrganizationalUnitId(organizationalUnitId);
            deposit.setLicenseId(this.licenseId);
            Deposit resDeposit = (Deposit)restClt.postForObject(this.preIngestUrl + "/deposits", (Object)deposit, Deposit.class, new Object[0]);
            if (resDeposit == null || resDeposit.getResId() == null) {
                log.error("{} Cannot create deposit (name={})", (Object)prefix, (Object)title);
                return null;
            }
            log.info("{} Deposit created: {} (ID={})", new Object[]{prefix, title, resDeposit.getResId()});
            return resDeposit;
        }
        catch (Exception e) {
            log.error("{} Cannot send deposit (name={}): {}", new Object[]{prefix, title, e.getMessage(), e});
            return null;
        }
    }

    protected void downloadContentWithToken(String url, Path path) {
        this.restClientTool.downloadContent(URI.create(url), path, TokenUsage.WITH_TOKEN);
    }
}

